"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoragesValidator = void 0;
const express_validator_1 = require("express-validator");
const validator_handle_1 = require("../../utils/handlers/validator.handle");
const abstract_validator_1 = require("../abstract.validator");
class StoragesValidator extends abstract_validator_1.AbstractValidator {
    constructor() {
        super();
    }
    getItem() {
        return [
            (0, express_validator_1.check)("_id").exists().isString(),
            (req, res, next) => {
                (0, validator_handle_1.validateResult)(req, res, next);
            },
        ];
    }
    getDownload() {
        return [
            (0, express_validator_1.check)("_id").exists().isString(),
            (req, res, next) => {
                (0, validator_handle_1.validateResult)(req, res, next);
            },
        ];
    }
    createItem() {
        return [
            (0, express_validator_1.check)("category").exists().isString(),
            (req, res, next) => {
                (0, validator_handle_1.validateResult)(req, res, next);
            },
        ];
    }
    updateItem() {
        return [
            (0, express_validator_1.check)("_id").exists().isMongoId(),
            (0, express_validator_1.check)("category").exists().isString(),
            (req, res, next) => {
                (0, validator_handle_1.validateResult)(req, res, next);
            },
        ];
    }
}
exports.StoragesValidator = StoragesValidator;
