"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractValidator = void 0;
const express_validator_1 = require("express-validator");
const validator_handle_1 = require("../utils/handlers/validator.handle");
class AbstractValidator {
    getItems() {
        return [
            (req, res, next) => {
                (0, validator_handle_1.validateResult)(req, res, next);
            },
        ];
    }
    getItem() {
        return [
            (0, express_validator_1.check)("_id").exists().isMongoId(),
            (req, res, next) => {
                (0, validator_handle_1.validateResult)(req, res, next);
            },
        ];
    }
    createItem() {
        return [
            (req, res, next) => {
                (0, validator_handle_1.validateResult)(req, res, next);
            },
        ];
    }
    updateItem() {
        return [
            (0, express_validator_1.check)("_id").exists().isMongoId(),
            (req, res, next) => {
                (0, validator_handle_1.validateResult)(req, res, next);
            },
        ];
    }
    deleteItem() {
        return [
            (0, express_validator_1.check)("_id").exists().isMongoId(),
            (req, res, next) => {
                (0, validator_handle_1.validateResult)(req, res, next);
            },
        ];
    }
}
exports.AbstractValidator = AbstractValidator;
