"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.queryTimePlugin = void 0;
const queryTimePlugin = (schema, options) => {
    schema.pre(["find", "findOne", "aggregate"], function () {
        this.start = Date.now();
    });
    schema.post(["find", "findOne", "aggregate"], function (docs) {
        if (!Array.isArray(docs)) {
            docs = [docs];
        }
        try {
            if (docs.length > 0) {
                if (docs[0] && docs[0]._id) {
                    docs[0].queryTime = Date.now() - this.start;
                }
                else if (docs[0] && docs[0].docs) {
                    docs[0].docs = docs[0].docs.map((d) => {
                        return { ...d, queryTime: Date.now() - this.start };
                    });
                }
            }
        }
        catch (error) { }
        return docs;
    });
};
exports.queryTimePlugin = queryTimePlugin;
