"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Json2SwaggerConverter = void 0;
const Json2SwaggerConverter = json => {
    "use strict";
    var inJSON, outSwagger, tabCount, indentator;
    function changeIndentation(count) {
        let i;
        if (count >= tabCount) {
            i = tabCount;
        }
        else {
            i = 0;
            indentator = "\n";
        }
        for (; i < count; i++) {
            indentator += "\t";
        }
        tabCount = count;
    }
    function conversorSelection(obj) {
        changeIndentation(tabCount + 1);
        if (typeof obj === "number") {
            outSwagger += indentator + '"type": "number"';
        }
        else if (Object.prototype.toString.call(obj) === "[object Array]") {
            convertArray(obj[0]);
        }
        else if (typeof obj === "string") {
            convertString(obj);
        }
        else if (typeof obj === "object") {
            convertObject(obj);
        }
        else if (typeof obj === "boolean") {
            outSwagger += indentator + '"type": "boolean"';
        }
        else {
            console.log('Property type "' + typeof obj + '" not valid for Swagger definitions');
        }
        changeIndentation(tabCount - 1);
    }
    function convertString(str) {
        let regxDate = /^(19|20)\d{2}-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])$/, regxDateTime = /^(19|20)\d{2}-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01]).([0-1][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9](\.[0-9]{1,2})?(Z|(\+|\-)([0-1][0-9]|2[0-3]):[0-5][0-9])$/;
        outSwagger += indentator + '"type": "string"';
        if (regxDateTime.test(str)) {
            outSwagger += ",";
            outSwagger += indentator + '"format": "date-time"';
        }
        else if (regxDate.test(str)) {
            outSwagger += ",";
            outSwagger += indentator + '"format": "date"';
        }
    }
    function convertArray(obj) {
        outSwagger += indentator + '"type": "array",';
        outSwagger += indentator + '"items": {';
        conversorSelection(obj);
        outSwagger += indentator + "}";
    }
    function convertObject(obj) {
        if (obj === null) {
            outSwagger += indentator + '"type": "String",';
            outSwagger += indentator + '"format": "nullable"';
            return;
        }
        outSwagger += indentator + '"type": "object",';
        outSwagger += indentator + '"properties": {';
        changeIndentation(tabCount + 1);
        for (var prop in obj) {
            outSwagger += indentator + '"' + prop + '": {';
            conversorSelection(obj[prop]);
            outSwagger += indentator + "},";
        }
        changeIndentation(tabCount - 1);
        if (Object.keys(obj).length > 0) {
            outSwagger = outSwagger.substring(0, outSwagger.length - 1);
            outSwagger += indentator + "}";
        }
        else {
            outSwagger += " }";
        }
    }
    function format(value, yaml) {
        if (yaml) {
            return value
                .replace(/[{},"]+/g, "")
                .replace(/\t/g, "  ")
                .replace(/(^ *\n)/gm, "");
        }
        else {
            return value;
        }
    }
    inJSON = json;
    try {
        inJSON = JSON.parse(inJSON);
    }
    catch (e) {
        console.log("Your JSON is invalid!\n(" + e + ")");
        return;
    }
    tabCount = 0;
    indentator = "\n";
    outSwagger = '{"definitions": {';
    changeIndentation(1);
    for (var obj in inJSON) {
        outSwagger += indentator + '"' + obj + '": {';
        conversorSelection(inJSON[obj]);
        outSwagger += indentator + "},";
    }
    outSwagger = outSwagger.substring(0, outSwagger.length - 1);
    changeIndentation(tabCount - 1);
    outSwagger += indentator + "}";
    outSwagger += indentator + "}";
    return format(outSwagger, false);
};
exports.Json2SwaggerConverter = Json2SwaggerConverter;
