"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.storagesRouter = void 0;
const storage_controller_1 = require("../../controllers/storage/storage.controller");
const auth_middleware_1 = require("../../middleware/auth.middleware");
const storage_validator_1 = require("../../validators/storage/storage.validator");
const abstract_route_1 = require("../abstract.route");
const express = require("express");
const router = express.Router();
const controller = new storage_controller_1.StoragesController();
class StoragesRoute extends abstract_route_1.AbstractRoute {
    constructor(_controller, _router) {
        super(_controller, _router, new storage_validator_1.StoragesValidator(), [
            "getItem",
            "getItems",
            "createItem",
            "deleteItem",
            "getDownload"
        ]);
    }
    createItem() {
        this.router.post("/", auth_middleware_1.AuthMiddleware, this.controller.createItem.bind(this.controller));
    }
    getDownload() {
        this.router.get("/download/:_id", this.validator.getDownload(), this.controller.download.bind(this.controller));
    }
}
exports.storagesRouter = new StoragesRoute(controller, router).init();
