"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListSwagger = void 0;
const ListSwagger = (schema) => {
    return {
        type: "object",
        properties: {
            totalDocs: { type: "number" },
            offset: { type: "number" },
            limit: { type: "number" },
            totalPages: { type: "number" },
            page: { type: "number" },
            pagingCounter: { type: "number" },
            hasPrevPage: { type: "boolean" },
            hasNextPage: { type: "boolean" },
            prevPage: { type: "number" },
            nextPage: { type: "number" },
            docs: { type: "array", items: { $ref: '#/definitions/' + schema } },
        },
    };
};
exports.ListSwagger = ListSwagger;
