"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.customsSchema = exports.AbstractModel = void 0;
const addStore_mongoose_plugin_1 = require("../utils/plugins/addStore.mongoose.plugin");
const filterStore_mongoose_plugin_1 = require("../utils/plugins/filterStore.mongoose.plugin");
const loadedAt_mogoose_plugin_1 = require("../utils/plugins/loadedAt.mogoose.plugin");
const queryTime_mongoose_plugin_1 = require("../utils/plugins/queryTime.mongoose.plugin");
const mongoosePaginate = require("mongoose-paginate-v2");
const mongoosePaginateAggregate = require("mongoose-aggregate-paginate-v2");
const mongoseDelete = require("mongoose-delete");
class AbstractModel {
    constructor() { }
}
exports.AbstractModel = AbstractModel;
const customsSchema = (schema) => {
    schema.plugin(loadedAt_mogoose_plugin_1.loadedAtPlugin);
    schema.plugin(filterStore_mongoose_plugin_1.filterStorePlugin);
    schema.plugin(queryTime_mongoose_plugin_1.queryTimePlugin);
    schema.plugin(addStore_mongoose_plugin_1.addStorePlugin, {});
    schema.plugin(mongoosePaginate);
    schema.plugin(mongoosePaginateAggregate);
    schema.plugin(mongoseDelete, {
        overrideMethods: true,
        deletedAt: true,
    });
};
exports.customsSchema = customsSchema;
