"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dbConnect = void 0;
const mongoose = require("mongoose");
const { ServerApiVersion } = require("mongodb");
const dbConnect = async () => {
    const port = process.argv[3];
    const DB_URI = process.env.DB_URI + (port ? port : "");
    mongoose.Promise = global.Promise;
    mongoose.connect(DB_URI, {
        serverApi: ServerApiVersion.v1,
        useNewUrlParser: true,
        useUnifiedTopology: true,
    });
    return true;
};
exports.dbConnect = dbConnect;
