import { check } from "express-validator";
import { validateResult } from "../../utils/handlers/validator.handle";
import { AbstractValidator } from "../abstract.validator";

export class StoragesValidator extends AbstractValidator {
  constructor() {
    super();
  }
  getItem() {
    return [
      check("_id").exists().isString(),
      (req, res, next) => { 
        validateResult(req, res, next);
      },
    ];
  }
  getDownload() {
    return [
      check("_id").exists().isString(),
      (req, res, next) => { 
        validateResult(req, res, next);
      },
    ];
  }
  createItem() {
    return [
      check("category").exists().isString(),
      (req, res, next) => {
        validateResult(req, res, next);
      },
    ];
  }
  updateItem() {
    return [
      check("_id").exists().isMongoId(),
      check("category").exists().isString(),
      (req, res, next) => {
        validateResult(req, res, next);
      },
    ];
  }
}
