import { check } from "express-validator";
import { validateResult } from "../../utils/handlers/validator.handle";
import { AbstractValidator } from "../abstract.validator";

export class SamplesValidator extends AbstractValidator {
  constructor() {
    super();
  }
  createItem() {
    return [
      (req, res, next) => {
        validateResult(req, res, next);
      },
    ];
  }
  updateItem() {
    return [
      check("_id").exists().isMongoId(),
      (req, res, next) => {
        validateResult(req, res, next);
      },
    ];
  }
}
