const multer = require("multer");

const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, `${__dirname}/../../storage`);
  },
  filename: (req, file, cb) => {
    const ext = file.originalname.split(".").pop();
    const filename = `file-${Date.now()}.${ext}`;
    cb(null, filename);
  },
});

export const upload = multer({
  storage,
  // limits: { fileSize: 1 * 1024 * 1024 } // Límite de tamaño del archivo: 1 MB
});
