export interface FindData {
  acknowledged: boolean;
  modifiedCount: number;
  upsertedId?: any;
  upsertedCount: number;
  matchedCount: number;
}

export interface RootObject {
  findData: FindData;
  deleted: boolean;
}

import { AbstractSchema } from "./abstract.schema";
class DeleteSchema extends AbstractSchema {
  constructor(schemas) {
    super(schemas);
  }
}
const parentSchema: RootObject = {
  findData: {
    acknowledged: true,
    modifiedCount: 1,
    upsertedId: null,
    upsertedCount: 0,
    matchedCount: 1,
  },
  deleted: true,
};
export const schema = new DeleteSchema({parentSchema});
