import { Json2SwaggerConverter } from "../utils/converters/json2swagger.converter";
import * as generateSchema from "generate-schema";

export class AbstractSchema {
  schemas: any = {};
  constructor(schemas) {
    Object.keys(schemas).forEach((schema) => {
      this.schemas[schema] = schemas[schema];
    });
  }
  mongoose(json: object) {
    return generateSchema.mongoose(json);
  }
  swagger(json) {
    return JSON.parse(Json2SwaggerConverter(JSON.stringify(json)));
  }
}
