import { AuthMiddleware } from "../middleware/auth.middleware";
import { AbstractValidator } from "../validators/abstract.validator";

export class AbstractRoute {
  router;
  controller;
  methods = [];
  customMethods = [];
  validator;

  constructor(
    controller,
    _router,
    validator = new AbstractValidator(),
    methods = ["getItem", "getItems", "createItem", "updateItem", "deleteItem"]
  ) {
    this.controller = controller;
    this.router = _router;
    this.methods = methods;
    this.validator = validator;
  }
  getItems() {
    this.router.get(
      "/",
      AuthMiddleware,
      this.validator.getItems(),
      this.controller.getItems.bind(this.controller)
    );
  }
  getItem() {
    this.router.get(
      "/:_id",
      AuthMiddleware,
      this.validator.getItem(),
      this.controller.getItem.bind(this.controller)
    );
  }
  createItem() {
    this.router.post(
      "/",
      AuthMiddleware,
      this.validator.createItem(),
      this.controller.createItem.bind(this.controller)
    );
  }
  updateItem() {
    this.router.put(
      "/:_id",
      AuthMiddleware,
      this.validator.updateItem(),
      this.controller.updateItem.bind(this.controller)
    );
  }
  deleteItem() {
    this.router.delete(
      "/:_id",
      AuthMiddleware,
      this.validator.deleteItem(),
      this.controller.deleteItem.bind(this.controller)
    );
  }

  init() {
    for (const method of [...this.methods, ...this.customMethods]) {
      this[method]();
    }
    return this.router;
  }
}
