import { schema as StoragesSchema } from "../../schemas/storage/storage.schema";
import { schema as DeleteSchema } from "../../schemas/delete.schema";

import mongoose from "mongoose";
import { customsSchema } from "../abstract.model";

const collection = "storages";

const schemaModelsMongoose = StoragesSchema.mongoose(
  StoragesSchema.schemas.parentSchema
);
const AbstractSchemaOptions = {
  timestamps: true,
  versionKey: false,
};
const Schema = new mongoose.Schema(schemaModelsMongoose, AbstractSchemaOptions);

customsSchema(Schema);

const getItem = StoragesSchema.swagger({
  _id: "String",
  ...StoragesSchema.schemas.parentSchema,
}).definitions;
const deleteItem = DeleteSchema.swagger(
  DeleteSchema.schemas.parentSchema
).definitions;

export const StoragesModel = mongoose.model(collection, Schema);
export const StoragesModelSwagger = {
  StoragesGetItem: {
    type: "object",
    properties: getItem,
  },
  StoragesGetItems: {
    type: "object",
    properties: getItem,
  },
  StoragesCreateItem: {
    type: "object",
    properties: getItem,
  },
  StoragesUpdateItem: {
    type: "object",
    properties: getItem,
  },
  StoragesDeleteItem: {
    type: "object",
    properties: deleteItem,
  },
};
