import { schema as SamplesSchema } from "../../schemas/sample/sample.schema";
import { schema as DeleteSchema } from "../../schemas/delete.schema";

import mongoose from "mongoose";
import { customsSchema } from "../abstract.model";

const collection = "samplesModel";

const schemaModelsMongoose = SamplesSchema.mongoose(
  SamplesSchema.schemas.parentSchema
);
const AbstractSchemaOptions = {
  timestamps: true,
  versionKey: false,
};
const Schema = new mongoose.Schema(schemaModelsMongoose, AbstractSchemaOptions);

customsSchema(Schema);

const getItem = SamplesSchema.swagger({
  _id: "String",
  ...SamplesSchema.schemas.parentSchema,
}).definitions;
const deleteItem = DeleteSchema.swagger(
  DeleteSchema.schemas.parentSchema
).definitions;

export const SamplesModel = mongoose.model(collection, Schema);
export const SamplesModelSwagger = {
  SamplesGetItem: {
    type: "object",
    properties: getItem,
  },
  SamplesGetItems: {
    type: "object",
    properties: getItem,
  },
  SamplesCreateItem: {
    type: "object",
    properties: getItem,
  },
  SamplesUpdateItem: {
    type: "object",
    properties: getItem,
  },
  SamplesDeleteItem: {
    type: "object",
    properties: deleteItem,
  },
};
