import { addStorePlugin } from "../utils/plugins/addStore.mongoose.plugin";
import { filterStorePlugin } from "../utils/plugins/filterStore.mongoose.plugin";
import { loadedAtPlugin } from "../utils/plugins/loadedAt.mogoose.plugin";
import { queryTimePlugin } from "../utils/plugins/queryTime.mongoose.plugin";

const mongoosePaginate = require("mongoose-paginate-v2");
const mongoosePaginateAggregate = require("mongoose-aggregate-paginate-v2");
const mongoseDelete = require("mongoose-delete");

export class AbstractModel {
  constructor() {}
}

export const customsSchema = (schema) => {
  schema.plugin(loadedAtPlugin);
  schema.plugin(filterStorePlugin);
  schema.plugin(queryTimePlugin);
  schema.plugin(addStorePlugin, {});
  schema.plugin(mongoosePaginate);
  schema.plugin(mongoosePaginateAggregate);
  schema.plugin(mongoseDelete, {
    overrideMethods: true,
    deletedAt: true,
  });
};
