import useragent from "express-useragent";
import { RateLimitMiddleware } from "./rate-limit.middleware";
import { SlowDownMiddleware } from "./slow-down.middleware";
import { CorsMiddleware } from "./cors.middleware";
import { HeadersMiddleware } from "./headers.middleware";
import { BodyParserMiddleware } from "./body-parser.middleware";
import { EndpointsMiddleware } from "./endpoints.middleware";
import helmet from "helmet";

export const MainMiddleware = (app, server) => {
  app.use(SlowDownMiddleware);
  app.use(RateLimitMiddleware);
  app.use(useragent.express());
  app.use(helmet());
  BodyParserMiddleware(app);
  app.use(HeadersMiddleware);
  app.use((req, res, next) => {
    console.log(req.originalUrl);
    EndpointsMiddleware(req, res, next, app);
  });
  app.use((req, res, next) => {
    CorsMiddleware(req, res, next, app);
  });
  app.set("trust proxy", 1);
  app.enable("trust proxy");
};
