import mongoose from "mongoose";
import { AbstractMethods } from "../abstract.method";
import fs from 'fs';
import path from 'path';

export class StoragesMethods extends AbstractMethods {
  constructor(model) {
    super(model);
  }
  /**
 * Sends a file using the HLS protocol.
 * @param filePath - The path to the file to send.
 * @param fileSize - The size of the file to send.
 * @param req - The HTTP request object.
 * @param res - The HTTP response object.
 * @param contentType - The MIME type of the file to send.
 */
  sendHlsFile(
    filePath: string,
    fileSize: number,
    req: Request | any,
    res: Response | any,
    contentType: string
  ) {
    const range = req.headers.range;
    if (range) {
      const parts = range.replace(/bytes=/, '').split('-');
      const start = parseInt(parts[0], 10);
      const end = parts[1] ? parseInt(parts[1], 10) : fileSize - 1;
      const chunksize = end - start + 1;
      const file = fs.createReadStream(filePath, { start, end });
      const head = {
        'Content-Range': `bytes ${start}-${end}/${fileSize}`,
        'Accept-Ranges': 'bytes',
        'Content-Length': chunksize,
        'Content-Type': contentType,
      };
      res.writeHead(206, head);
      file.pipe(res);
    } else {
      const head = {
        'Content-Length': fileSize,
        'Content-Type': contentType,
      };
      res.writeHead(200, head);
      fs.createReadStream(filePath).pipe(res);
    }
  }
}
