import swaggerJSDoc, { OAS3Definition, OAS3Options } from "swagger-jsdoc";
import { SamplesModelSwagger } from "../models/sample/sample.model";

import { ListSwagger } from "../models/list.model";
import { StoragesModelSwagger } from "../models/storage/storage.model";

function setSchemas(method, prefix) {
  return {
    [prefix + "GetItemSchema"]: method[prefix + "GetItem"],
    [prefix + "GetItemsSchema"]: ListSwagger(prefix + "GetItemSchema"),
    [prefix + "CreateItemSchema"]: method[prefix + "CreateItem"],
    [prefix + "UpdateItemSchema"]: method[prefix + "UpdateItem"],
    [prefix + "DeleteItemSchema"]: method[prefix + "DeleteItem"],
  };
}


const URL_SERVER = process.env.URL_SWAGGER;
const schemas = {

  ...setSchemas(StoragesModelSwagger, "Storages"),

  SamplesGetItemSchema: SamplesModelSwagger.SamplesGetItem,
  SamplesGetItemsSchema: ListSwagger("SamplesGetItemSchema"),
  SamplesCreateItemSchema: SamplesModelSwagger.SamplesCreateItem,
  SamplesUpdateItemSchema: SamplesModelSwagger.SamplesUpdateItem,
  SamplesDeleteItemSchema: SamplesModelSwagger.SamplesDeleteItem,

  ErrorSchema: {
    type: "object",
    required: ["error"],
    properties: {
      error: {
        type: "string",
        nullable: true,
      },
      errors: {
        type: "array",
        nullable: true,
        items: {
          type: "object",
          properties: {
            message: { type: "string" },
            param: { type: "string" },
            location: { type: "string" },
          },
        },
      },
    },
  },
};
const swaggerDefinition: OAS3Definition = {
  openapi: "3.0.0",
  info: {
    title: "Documentacion de mi API",
    version: "1.0.0",
  },
  servers: [
    {
      url: URL_SERVER + "/v1/api",
    },
  ],
  definitions: schemas,
  components: {
    parameters: {
      store: {
        in: "header",
        name: "store",
        required: true,
        schema: {
          type: "string",
          minimum: 1,
          default: "000111222333444555666777",
        },
        description: "Current store",
      },
      pageParam: {
        in: "query",
        name: "page",
        required: false,
        schema: {
          type: "integer",
          minimum: 1,
          default: 1,
        },
        description: "The current page to return",
      },
      limitParam: {
        in: "query",
        name: "limit",
        required: false,
        schema: {
          type: "integer",
          minimum: 1,
          maximum: 50,
          default: 10,
        },
        description: "The numbers of items to return.",
      },
    },
    securitySchemes: {
      bearerAuth: {
        type: "http",
        scheme: "bearer",
      },
    },
    schemas: schemas,
  },
  security: [
    {
      bearerAuth: [],
    },
  ],
};

const swaggerOptions: OAS3Options = {
  swaggerDefinition,
  apis: ["./app/routes/**/*.ts"],
};
export default swaggerJSDoc(swaggerOptions);

// const swaggerAutogen = require('swagger-autogen')()

// swaggerAutogen('./swagger-output.json', ['./dist/routes/api.route.js']);
