"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadedAtPlugin = void 0;
const loadedAtPlugin = (schema, options) => {
    schema.post(["find", "findOne", "aggregate"], function (docs) {
        const now = new Date();
        if (!Array.isArray(docs)) {
            docs = [docs];
        }
        try {
            if (docs.length === 1) {
                if (docs[0] && docs[0]._id) {
                    docs[0].loadedAt = now;
                }
                else if (docs[0] && docs[0].docs) {
                    docs[0].docs = docs[0].docs.map((d) => {
                        return { ...d, loadedAt: now };
                    });
                }
            }
            else {
                docs = docs.map((d) => {
                    return { ...d, loadedAt: now };
                });
            }
        }
        catch (error) { }
        return docs;
    });
};
exports.loadedAtPlugin = loadedAtPlugin;
