"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractRoute = void 0;
const auth_middleware_1 = require("../middleware/auth.middleware");
const abstract_validator_1 = require("../validators/abstract.validator");
class AbstractRoute {
    constructor(controller, _router, validator = new abstract_validator_1.AbstractValidator(), methods = ["getItem", "getItems", "createItem", "updateItem", "deleteItem"]) {
        this.methods = [];
        this.customMethods = [];
        this.controller = controller;
        this.router = _router;
        this.methods = methods;
        this.validator = validator;
    }
    getItems() {
        this.router.get("/", auth_middleware_1.AuthMiddleware, this.validator.getItems(), this.controller.getItems.bind(this.controller));
    }
    getItem() {
        this.router.get("/:_id", auth_middleware_1.AuthMiddleware, this.validator.getItem(), this.controller.getItem.bind(this.controller));
    }
    createItem() {
        this.router.post("/", auth_middleware_1.AuthMiddleware, this.validator.createItem(), this.controller.createItem.bind(this.controller));
    }
    updateItem() {
        this.router.put("/:_id", auth_middleware_1.AuthMiddleware, this.validator.updateItem(), this.controller.updateItem.bind(this.controller));
    }
    deleteItem() {
        this.router.delete("/:_id", auth_middleware_1.AuthMiddleware, this.validator.deleteItem(), this.controller.deleteItem.bind(this.controller));
    }
    init() {
        for (const method of [...this.methods, ...this.customMethods]) {
            this[method]();
        }
        return this.router;
    }
}
exports.AbstractRoute = AbstractRoute;
