"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MainMiddleware = void 0;
const express_useragent_1 = __importDefault(require("express-useragent"));
const rate_limit_middleware_1 = require("./rate-limit.middleware");
const slow_down_middleware_1 = require("./slow-down.middleware");
const cors_middleware_1 = require("./cors.middleware");
const headers_middleware_1 = require("./headers.middleware");
const body_parser_middleware_1 = require("./body-parser.middleware");
const endpoints_middleware_1 = require("./endpoints.middleware");
const helmet_1 = __importDefault(require("helmet"));
const MainMiddleware = (app, server) => {
    app.use(slow_down_middleware_1.SlowDownMiddleware);
    app.use(rate_limit_middleware_1.RateLimitMiddleware);
    app.use(express_useragent_1.default.express());
    app.use((0, helmet_1.default)());
    (0, body_parser_middleware_1.BodyParserMiddleware)(app);
    app.use(headers_middleware_1.HeadersMiddleware);
    app.use((req, res, next) => {
        console.log(req.originalUrl);
        (0, endpoints_middleware_1.EndpointsMiddleware)(req, res, next, app);
    });
    app.use((req, res, next) => {
        (0, cors_middleware_1.CorsMiddleware)(req, res, next, app);
    });
    app.set("trust proxy", 1);
    app.enable("trust proxy");
};
exports.MainMiddleware = MainMiddleware;
