"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthMiddleware = void 0;
const app_const_1 = require("../utils/consts/app.const");
const error_handle_1 = require("../utils/handlers/error.handle");
const axios_1 = __importDefault(require("axios"));
const AuthMiddleware = async (req, res, next) => {
    var _a;
    try {
        if (!req.headers.authorization) {
            (0, error_handle_1.handleErrorResponse)(res, "TOKEN_NOT_FOUND", 403);
            return;
        }
        const token = req.headers.authorization.split('Bearer ')[0];
        console.log(token);
        const store = (_a = req.headers.store) !== null && _a !== void 0 ? _a : "";
        (0, axios_1.default)({
            url: process.env.URL_AUTH + app_const_1.version + "/" + app_const_1.api_url + "/auth/check",
            method: "POST",
            headers: {
                store,
                Authorization: "Bearer " + token,
            },
            data: {},
        })
            .then((response) => {
            if (response.data.status === true) {
                req.user_id = response.data.data._id;
                next();
            }
            else {
                (0, error_handle_1.handleErrorResponse)(res, "NOT_ALLOW_TOKEN_INVALID", 403);
            }
        })
            .catch((e) => {
            console.log(e);
            (0, error_handle_1.handleHttpError)(res, e);
        });
    }
    catch (e) {
        (0, error_handle_1.handleHttpError)(res, e);
    }
};
exports.AuthMiddleware = AuthMiddleware;
