"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractMethods = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
class AbstractMethods {
    constructor(model) {
        this.model = model;
    }
    mainFilter(request) {
        const store = request.headers.store;
        let storeMatch = [];
        if (mongoose_1.default.Types.ObjectId.isValid(store)) {
            storeMatch = [
                {
                    $match: {
                        store_id: new mongoose_1.default.Types.ObjectId(store),
                        user_id: new mongoose_1.default.Types.ObjectId(request.user_id),
                    },
                },
            ];
        }
        else {
            storeMatch = [
                {
                    $match: {
                        store_id: store,
                        user_id: new mongoose_1.default.Types.ObjectId(request.user_id),
                    },
                },
            ];
        }
        return [...storeMatch];
    }
    async existDocument(filter) {
        return await this.model.findOne(filter).select("_id").lean();
    }
    async existDocuments(filter) {
        const promises = filter.map((f) => {
            return this.model.findOne(f).select("_id").lean();
        });
        return await Promise.allSettled(promises);
    }
    async saveDocument(data, req) {
        if (!req.headers.store) {
            return Error("STORE_NOT_FOUND");
        }
        if (!req.user_id) {
            return Error("USER_NOT_FOUND");
        }
        return await this.model.create({ ...data, store_id: req.headers.store, user_id: req.user_id });
    }
    async saveDocuments() { }
}
exports.AbstractMethods = AbstractMethods;
