"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UtilsController = void 0;
const abstract_controller_1 = require("./abstract.controller");
const util_method_1 = require("../methods/util.method");
const abstract_model_1 = require("../models/abstract.model");
class UtilsController extends abstract_controller_1.AbstractController {
    constructor() {
        super(abstract_model_1.AbstractModel);
        this.methods = new util_method_1.UtilsMethods(abstract_model_1.AbstractModel);
    }
    async endpointsUtils(req, res, next) {
        try {
            res.send(this.methods.endpointsUtils(req));
        }
        catch (e) {
            this.params.handleHttpError(res, e);
        }
    }
}
exports.UtilsController = UtilsController;
