import { check } from "express-validator";
import { validateResult } from "../utils/handlers/validator.handle";

export class AbstractValidator {
  getItems() {
    return [
      (req, res, next) => {
        validateResult(req, res, next);
      },
    ];
  }
  getItem() {
    return [
      check("_id").exists().isMongoId(),
      (req, res, next) => { 
        validateResult(req, res, next);
      },
    ];
  }
  createItem() {
    return [
      (req, res, next) => {
        validateResult(req, res, next);
      },
    ];
  }
  updateItem() {
    return [
      check("_id").exists().isMongoId(),
      (req, res, next) => {
        validateResult(req, res, next);
      },
    ];
  }
  deleteItem() {
    return [
      check("_id").exists().isMongoId(),
      (req, res, next) => {
        validateResult(req, res, next);
      },
    ];
  }
}
