interface RootObject {
  totalDocs: number;
  offset: number;
  limit: number;
  totalPages: number;
  page: number;
  pagingCounter: number;
  hasPrevPage: boolean;
  hasNextPage: boolean;
  prevPage?: any;
  nextPage?: any;
}

import { AbstractSchema } from "./abstract.schema";
class ListSchema extends AbstractSchema {
  constructor(schemas) {
    super(schemas);
  }
}
const parentSchema: RootObject = {
  totalDocs: 2,
  offset: 0,
  limit: 10,
  totalPages: 1,
  page: 1,
  pagingCounter: 1,
  hasPrevPage: false,
  hasNextPage: false,
  prevPage: 0,
  nextPage: 0,
};
const responseSchema: RootObject = {
  totalDocs: 2,
  offset: 0,
  limit: 10,
  totalPages: 1,
  page: 1,
  pagingCounter: 1,
  hasPrevPage: false,
  hasNextPage: false,
  prevPage: 0,
  nextPage: 0,
};
export const schema = new ListSchema({ parentSchema, responseSchema });
