import { SamplesController } from "../../controllers/sample/sample.controller";
import { SamplesValidator } from "../../validators/sample/sample.validator";
import { AbstractRoute } from "../abstract.route";

const express = require("express");
const router = express.Router();
const controller = new SamplesController();

class SamplesRoute extends AbstractRoute {
  constructor(_controller, _router) {
    super(_controller, _router, new SamplesValidator());
  }
  /**
   * Get all samplesComment
   * @swagger
   * /samplesRP:
   *    get:
   *      tags:
   *        - SampleTag
   *      summary: "Get all samplesComment"
   *      description: "List all samplesComment with details"
   *      security:
   *        - bearerAuth: []
   *      operationId: "GETsamples"
   *      produces:
   *      - "application/xml"
   *      - "application/json"
   *      parameters:
   *      - $ref: '#/components/parameters/store'
   *      - $ref: '#/components/parameters/pageParam'
   *      - $ref: '#/components/parameters/limitParam'
   *      - name: "sort"
   *        in: "query"
   *        description: "The type of sort of items to return."
   *        required: false
   *        schema:
   *          type: "string"
   *          enum: [createdAt, -createdAt]
   *      responses:
   *        "200":
   *          description: "successful operation"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/SamplesGetItemsSchema'
   *        "204":
   *          description: "successful operation with empty respose"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/SamplesGetItemsSchema'
   *        "401":
   *          description: "Not allow because you need a Authentication Token"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   *        '403':
   *          description: "Not allow because you need more permissions"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   *        "404":
   *          description: "samplesComment not found"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   *        default:
   *          description: "Unexpected Error"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   */
  /**
   * Find samplesComment by ID
   * @swagger
   * /samplesRP/{id}:
   *    get:
   *      tags:
   *        - SampleTag
   *      summary: "Find samplesComment by ID"
   *      description: "Returns a single samplesComment"
   *      security:
   *        - bearerAuth: []
   *      operationId: "GETsample"
   *      produces:
   *      - "application/xml"
   *      - "application/json"
   *      parameters:
   *      - $ref: '#/components/parameters/store'
   *      - name: "id"
   *        in: "path"
   *        description: "ID of samplesComment to return"
   *        required: true
   *      responses:
   *        "200":
   *          description: "successful operation"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/SamplesGetItemSchema'
   *        "204":
   *          description: "successful operation with empty respose"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/SamplesGetItemSchema'
   *        "401":
   *          description: "Not allow because you need a Authentication Token"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   *        '403':
   *          description: "Not allow because you need more permissions"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   *        "404":
   *          description: "samplesComment not found"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   *        default:
   *          description: "Unexpected Error"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   */
  /**
   * Add a samplesComment
   * @swagger
   * /samplesRP:
   *    post:
   *      tags:
   *        - SampleTag
   *      summary: "Add a samplesComment"
   *      description: "Add a samplesComment"
   *      operationId: "ADDsample"
   *      security:
   *        - bearerAuth: []
   *      parameters:
   *      - $ref: '#/components/parameters/store'
   *      requestBody:
   *        content:
   *          application/json:
   *            schema:
   *              $ref: "#/definitions/SamplesCreateItemSchema"
   *      responses:
   *        "200":
   *          description: "successful operation"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/SamplesGetItemSchema'
   *        "201":
   *          description: "Created successfully"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/SamplesGetItemSchema'
   *        "401":
   *          description: "Not allow because you need a Authentication Token"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   *        '403':
   *          description: "Not allow because you need more permissions"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   *        "404":
   *          description: "samplesComment not found"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   *        default:
   *          description: "Unexpected Error"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   */
  /**
   * Update a samplesComment
   * @swagger
   * /samplesRP/{id}:
   *    put:
   *      tags:
   *        - SampleTag
   *      summary: "Update a samplesComment"
   *      description: "Update an existing samplesComment"
   *      operationId: "UPDATEsample"
   *      security:
   *        - bearerAuth: []
   *      parameters:
   *      - $ref: '#/components/parameters/store'
   *      - name: "id"
   *        in: "path"
   *        description: "ID of samplesComment to update"
   *        required: true
   *      requestBody:
   *        content:
   *          application/json:
   *            schema:
   *              $ref: "#/definitions/SamplesUpdateItemSchema"
   *      responses:
   *        "200":
   *          description: "successful operation"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/SamplesGetItemSchema'
   *        "401":
   *          description: "Not allow because you need a Authentication Token"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   *        '403':
   *          description: "Not allow because you need more permissions"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   *        "404":
   *          description: "samplesComment not found"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   *        default:
   *          description: "Unexpected Error"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   */
  /**
   * Delete a samplesComment
   * @swagger
   * /samplesRP/{id}:
   *    delete:
   *      tags:
   *        - SampleTag
   *      summary: "Delete a samplesComment"
   *      description: "Delete an existing samplesComment"
   *      operationId: "DELETEsample"
   *      security:
   *        - bearerAuth: []
   *      parameters:
   *      - $ref: '#/components/parameters/store'
   *      - name: "id"
   *        in: "path"
   *        description: "ID of samplesComment to delete"
   *        required: true
   *      responses:
   *        "200":
   *          description: "successful operation"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/SamplesDeleteItemSchema'
   *        "401":
   *          description: "Not allow because you need a Authentication Token"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   *        '403':
   *          description: "Not allow because you need more permissions"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   *        "404":
   *          description: "samplesComment not found"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   *        default:
   *          description: "Unexpected Error"
   *          content:
   *            application/json:
   *              schema:
   *                $ref: '#/definitions/ErrorSchema'
   */
}

export const samplesRouter = new SamplesRoute(controller, router).init();
