import rateLimit from "express-rate-limit";

const limiter = rateLimit({
  windowMs: 15 * 10 * 1000, // 15 minutes
  max: 300, // Limit each IP to 100 requests per `window` (here, per 15 minutes)
  standardHeaders: true, // Return rate limit info in the `RateLimit-*` headers
  legacyHeaders: false, // Disable the `X-RateLimit-*` headers
});
export const RateLimitMiddleware = limiter
