require("dotenv").config();
import cluster from "cluster";
import os from "os";

import express from "express";
import { dbConnect } from "./config/mongo";
import swaggerUi from "swagger-ui-express";
import swaggerSetup from "./docs/swagger";
import fs from "fs";
import { MainMiddleware } from "./middleware/main.middleware";
import { apiRouter } from "./routes/api.route";

import { api_url, version } from "./utils/consts/app.const";

const app = require("express")();
const http = require("http").Server(app);

const port = process.argv[3] || process.env.PORT || "8080";

// let sequelize = {};
app.use("/documentation", swaggerUi.serve, swaggerUi.setup(swaggerSetup));
app.get("/swagger/schema.json", (req, res) => {
  res.setHeader("Content-Type", "application/json");
  const swagger: any = swaggerSetup;
  for (const key in swagger.paths) {
    if (Object.prototype.hasOwnProperty.call(swagger.paths, key)) {
      const path = swagger.paths[key];
      for (const k in path) {
        if (Object.prototype.hasOwnProperty.call(path, k)) {
          delete swagger.paths[key][k].operationId;
        }
      }
    }
  }

  res.send(swagger);
});

app.use("/storage", express.static(__dirname + "/storage"));
MainMiddleware(app, http);

if (cluster.isPrimary) {

  const maxCPU = process.env.CPUS || Math.ceil(os.cpus().length / 2);

  for (let i = 0; i < +maxCPU; i++) {
    cluster.fork();
  }
  cluster.on("exit", (worker, code, signal) => {
    cluster.fork();
  });

} else {
  const routerVersion = express.Router();
  app.get("/ping", (req: any, res: any) => {
    return res.send({ res: "pong", status: 200 });
  });

  // app.use((req, res, next) => {
  //   // console.log(sequelize)
  //   req.sequelize = sequelize
  //   next();
  // });
  // API GENERAL
  routerVersion.use("/" + api_url, apiRouter);
  // API GENERAL

  app.get("/builder", (req, res) => {
    const kebabize = (str) => {
      return str
        .split("")
        .map((letter, idx) => {
          return letter.toUpperCase() === letter
            ? `${idx !== 0 ? "-" : ""}${letter.toLowerCase()}`
            : letter;
        })
        .join("");
    };
    const spacing = (str) => {
      return str
        .split("")
        .map((letter, idx) => {
          return letter.toUpperCase() === letter
            ? `${idx !== 0 ? " " : ""}${letter.toLowerCase()}`
            : letter;
        })
        .join("");
    };
    const routerPath = (name, prefix) => {
      let restante = name.split(prefix + "s").join("");
      const estante = restante.charAt(0).toLowerCase() + restante.slice(1);
      return `${prefix}s/${kebabize(estante)}s`;
    };
    function createSample(name, extension, prefix) {
      const folder = `/${prefix}/`;
      if (!fs.existsSync(`./app/${extension}s${folder}`)) {
        fs.mkdirSync(`./app/${extension}s${folder}`);
      }
      const filePath = `./app/${extension}s${folder}${kebabize(
        name
      )}.${extension}.ts`;
      const samplePath = `./app/${extension}s/sample/sample.${extension}.ts`;
      fs.readFile(samplePath, { encoding: "utf-8" }, function (err, data) {
        if (!err) {
          data = data
            .split("SampleTag")
            .join(prefix.charAt(0).toUpperCase() + prefix.slice(1) + "s");
          data = data.split("samplesModel").join(`${kebabize(name)}s`);
          data = data.split("samplesRP").join(routerPath(name, prefix));
          data = data.split("samplesComment").join(spacing(name));
          data = data.split("/sample/").join(folder);
          data = data.split("sample.").join(`${kebabize(name)}.`);
          data = data.split("sample").join(name);
          data = data
            .split("Sample")
            .join(name.charAt(0).toUpperCase() + name.slice(1));
          fs.writeFile(filePath, data, function (err) {
            if (err) {
              return console.error(err);
            }
            console.log("File created!");
          });
        } else {
          console.log(err);
        }
      });
    }
    const name = "storage"; // templateStorage
    const folder = "storage"; // template-storage
    createSample(name, "controller", folder);
    createSample(name, "method", folder);
    createSample(name, "model", folder);
    createSample(name, "route", folder);
    createSample(name, "schema", folder);
    createSample(name, "validator", folder);
  });

  app.use(version, routerVersion);

  dbConnect().then((response) => {
    // sequelize = response

    http.listen(port, () => {
      console.log(
        `Servidor corriendo en http://localhost: ${port} - ${process.pid}`
      );
    });
  });
}