"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SamplesValidator = void 0;
const express_validator_1 = require("express-validator");
const validator_handle_1 = require("../../utils/handlers/validator.handle");
const abstract_validator_1 = require("../abstract.validator");
class SamplesValidator extends abstract_validator_1.AbstractValidator {
    constructor() {
        super();
    }
    createItem() {
        return [
            (req, res, next) => {
                (0, validator_handle_1.validateResult)(req, res, next);
            },
        ];
    }
    updateItem() {
        return [
            (0, express_validator_1.check)("_id").exists().isMongoId(),
            (req, res, next) => {
                (0, validator_handle_1.validateResult)(req, res, next);
            },
        ];
    }
}
exports.SamplesValidator = SamplesValidator;
