"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compare = exports.encrypt = exports.bcrypt = void 0;
exports.bcrypt = require("bcryptjs");
const encrypt = async (textPlain) => {
    const hash = await exports.bcrypt.hash(textPlain, 10);
    return hash;
};
exports.encrypt = encrypt;
const compare = async (passwordPlain, hashPassword) => {
    return await exports.bcrypt.compare(passwordPlain, hashPassword);
};
exports.compare = compare;
