"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoragesModelSwagger = exports.StoragesModel = void 0;
const storage_schema_1 = require("../../schemas/storage/storage.schema");
const delete_schema_1 = require("../../schemas/delete.schema");
const mongoose_1 = __importDefault(require("mongoose"));
const abstract_model_1 = require("../abstract.model");
const collection = "storages";
const schemaModelsMongoose = storage_schema_1.schema.mongoose(storage_schema_1.schema.schemas.parentSchema);
const AbstractSchemaOptions = {
    timestamps: true,
    versionKey: false,
};
const Schema = new mongoose_1.default.Schema(schemaModelsMongoose, AbstractSchemaOptions);
(0, abstract_model_1.customsSchema)(Schema);
const getItem = storage_schema_1.schema.swagger({
    _id: "String",
    ...storage_schema_1.schema.schemas.parentSchema,
}).definitions;
const deleteItem = delete_schema_1.schema.swagger(delete_schema_1.schema.schemas.parentSchema).definitions;
exports.StoragesModel = mongoose_1.default.model(collection, Schema);
exports.StoragesModelSwagger = {
    StoragesGetItem: {
        type: "object",
        properties: getItem,
    },
    StoragesGetItems: {
        type: "object",
        properties: getItem,
    },
    StoragesCreateItem: {
        type: "object",
        properties: getItem,
    },
    StoragesUpdateItem: {
        type: "object",
        properties: getItem,
    },
    StoragesDeleteItem: {
        type: "object",
        properties: deleteItem,
    },
};
