"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SamplesModelSwagger = exports.SamplesModel = void 0;
const sample_schema_1 = require("../../schemas/sample/sample.schema");
const delete_schema_1 = require("../../schemas/delete.schema");
const mongoose_1 = __importDefault(require("mongoose"));
const abstract_model_1 = require("../abstract.model");
const collection = "samplesModel";
const schemaModelsMongoose = sample_schema_1.schema.mongoose(sample_schema_1.schema.schemas.parentSchema);
const AbstractSchemaOptions = {
    timestamps: true,
    versionKey: false,
};
const Schema = new mongoose_1.default.Schema(schemaModelsMongoose, AbstractSchemaOptions);
(0, abstract_model_1.customsSchema)(Schema);
const getItem = sample_schema_1.schema.swagger({
    _id: "String",
    ...sample_schema_1.schema.schemas.parentSchema,
}).definitions;
const deleteItem = delete_schema_1.schema.swagger(delete_schema_1.schema.schemas.parentSchema).definitions;
exports.SamplesModel = mongoose_1.default.model(collection, Schema);
exports.SamplesModelSwagger = {
    SamplesGetItem: {
        type: "object",
        properties: getItem,
    },
    SamplesGetItems: {
        type: "object",
        properties: getItem,
    },
    SamplesCreateItem: {
        type: "object",
        properties: getItem,
    },
    SamplesUpdateItem: {
        type: "object",
        properties: getItem,
    },
    SamplesDeleteItem: {
        type: "object",
        properties: deleteItem,
    },
};
