"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const swagger_jsdoc_1 = __importDefault(require("swagger-jsdoc"));
const sample_model_1 = require("../models/sample/sample.model");
const list_model_1 = require("../models/list.model");
const storage_model_1 = require("../models/storage/storage.model");
function setSchemas(method, prefix) {
    return {
        [prefix + "GetItemSchema"]: method[prefix + "GetItem"],
        [prefix + "GetItemsSchema"]: (0, list_model_1.ListSwagger)(prefix + "GetItemSchema"),
        [prefix + "CreateItemSchema"]: method[prefix + "CreateItem"],
        [prefix + "UpdateItemSchema"]: method[prefix + "UpdateItem"],
        [prefix + "DeleteItemSchema"]: method[prefix + "DeleteItem"],
    };
}
const URL_SERVER = process.env.URL_SWAGGER;
const schemas = {
    ...setSchemas(storage_model_1.StoragesModelSwagger, "Storages"),
    SamplesGetItemSchema: sample_model_1.SamplesModelSwagger.SamplesGetItem,
    SamplesGetItemsSchema: (0, list_model_1.ListSwagger)("SamplesGetItemSchema"),
    SamplesCreateItemSchema: sample_model_1.SamplesModelSwagger.SamplesCreateItem,
    SamplesUpdateItemSchema: sample_model_1.SamplesModelSwagger.SamplesUpdateItem,
    SamplesDeleteItemSchema: sample_model_1.SamplesModelSwagger.SamplesDeleteItem,
    ErrorSchema: {
        type: "object",
        required: ["error"],
        properties: {
            error: {
                type: "string",
                nullable: true,
            },
            errors: {
                type: "array",
                nullable: true,
                items: {
                    type: "object",
                    properties: {
                        message: { type: "string" },
                        param: { type: "string" },
                        location: { type: "string" },
                    },
                },
            },
        },
    },
};
const swaggerDefinition = {
    openapi: "3.0.0",
    info: {
        title: "Documentacion de mi API",
        version: "1.0.0",
    },
    servers: [
        {
            url: URL_SERVER + "/v1/api",
        },
    ],
    definitions: schemas,
    components: {
        parameters: {
            store: {
                in: "header",
                name: "store",
                required: true,
                schema: {
                    type: "string",
                    minimum: 1,
                    default: "000111222333444555666777",
                },
                description: "Current store",
            },
            pageParam: {
                in: "query",
                name: "page",
                required: false,
                schema: {
                    type: "integer",
                    minimum: 1,
                    default: 1,
                },
                description: "The current page to return",
            },
            limitParam: {
                in: "query",
                name: "limit",
                required: false,
                schema: {
                    type: "integer",
                    minimum: 1,
                    maximum: 50,
                    default: 10,
                },
                description: "The numbers of items to return.",
            },
        },
        securitySchemes: {
            bearerAuth: {
                type: "http",
                scheme: "bearer",
            },
        },
        schemas: schemas,
    },
    security: [
        {
            bearerAuth: [],
        },
    ],
};
const swaggerOptions = {
    swaggerDefinition,
    apis: ["./app/routes/**/*.ts"],
};
exports.default = (0, swagger_jsdoc_1.default)(swaggerOptions);
