"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
require("dotenv").config();
const cluster_1 = __importDefault(require("cluster"));
const os_1 = __importDefault(require("os"));
const express_1 = __importDefault(require("express"));
const mongo_1 = require("./config/mongo");
const swagger_ui_express_1 = __importDefault(require("swagger-ui-express"));
const swagger_1 = __importDefault(require("./docs/swagger"));
const fs_1 = __importDefault(require("fs"));
const main_middleware_1 = require("./middleware/main.middleware");
const api_route_1 = require("./routes/api.route");
const app_const_1 = require("./utils/consts/app.const");
const app = require("express")();
const http = require("http").Server(app);
const port = process.argv[3] || process.env.PORT || "8080";
app.use("/documentation", swagger_ui_express_1.default.serve, swagger_ui_express_1.default.setup(swagger_1.default));
app.get("/swagger/schema.json", (req, res) => {
    res.setHeader("Content-Type", "application/json");
    const swagger = swagger_1.default;
    for (const key in swagger.paths) {
        if (Object.prototype.hasOwnProperty.call(swagger.paths, key)) {
            const path = swagger.paths[key];
            for (const k in path) {
                if (Object.prototype.hasOwnProperty.call(path, k)) {
                    delete swagger.paths[key][k].operationId;
                }
            }
        }
    }
    res.send(swagger);
});
app.use("/storage", express_1.default.static(__dirname + "/storage"));
(0, main_middleware_1.MainMiddleware)(app, http);
if (cluster_1.default.isPrimary) {
    const maxCPU = process.env.CPUS || Math.ceil(os_1.default.cpus().length / 2);
    for (let i = 0; i < +maxCPU; i++) {
        cluster_1.default.fork();
    }
    cluster_1.default.on("exit", (worker, code, signal) => {
        cluster_1.default.fork();
    });
}
else {
    const routerVersion = express_1.default.Router();
    app.get("/ping", (req, res) => {
        return res.send({ res: "pong", status: 200 });
    });
    routerVersion.use("/" + app_const_1.api_url, api_route_1.apiRouter);
    app.get("/builder", (req, res) => {
        const kebabize = (str) => {
            return str
                .split("")
                .map((letter, idx) => {
                return letter.toUpperCase() === letter
                    ? `${idx !== 0 ? "-" : ""}${letter.toLowerCase()}`
                    : letter;
            })
                .join("");
        };
        const spacing = (str) => {
            return str
                .split("")
                .map((letter, idx) => {
                return letter.toUpperCase() === letter
                    ? `${idx !== 0 ? " " : ""}${letter.toLowerCase()}`
                    : letter;
            })
                .join("");
        };
        const routerPath = (name, prefix) => {
            let restante = name.split(prefix + "s").join("");
            const estante = restante.charAt(0).toLowerCase() + restante.slice(1);
            return `${prefix}s/${kebabize(estante)}s`;
        };
        function createSample(name, extension, prefix) {
            const folder = `/${prefix}/`;
            if (!fs_1.default.existsSync(`./app/${extension}s${folder}`)) {
                fs_1.default.mkdirSync(`./app/${extension}s${folder}`);
            }
            const filePath = `./app/${extension}s${folder}${kebabize(name)}.${extension}.ts`;
            const samplePath = `./app/${extension}s/sample/sample.${extension}.ts`;
            fs_1.default.readFile(samplePath, { encoding: "utf-8" }, function (err, data) {
                if (!err) {
                    data = data
                        .split("SampleTag")
                        .join(prefix.charAt(0).toUpperCase() + prefix.slice(1) + "s");
                    data = data.split("samplesModel").join(`${kebabize(name)}s`);
                    data = data.split("samplesRP").join(routerPath(name, prefix));
                    data = data.split("samplesComment").join(spacing(name));
                    data = data.split("/sample/").join(folder);
                    data = data.split("sample.").join(`${kebabize(name)}.`);
                    data = data.split("sample").join(name);
                    data = data
                        .split("Sample")
                        .join(name.charAt(0).toUpperCase() + name.slice(1));
                    fs_1.default.writeFile(filePath, data, function (err) {
                        if (err) {
                            return console.error(err);
                        }
                        console.log("File created!");
                    });
                }
                else {
                    console.log(err);
                }
            });
        }
        const name = "storage";
        const folder = "storage";
        createSample(name, "controller", folder);
        createSample(name, "method", folder);
        createSample(name, "model", folder);
        createSample(name, "route", folder);
        createSample(name, "schema", folder);
        createSample(name, "validator", folder);
    });
    app.use(app_const_1.version, routerVersion);
    (0, mongo_1.dbConnect)().then((response) => {
        http.listen(port, () => {
            console.log(`Servidor corriendo en http://localhost: ${port} - ${process.pid}`);
        });
    });
}
